---
--- Sp_respondentconnectquotas
---
	
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_respondentconnectquotas]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[Sp_respondentconnectquotas]
GO

CREATE PROCEDURE [dbo].[Sp_respondentconnectquotas]
                @ProjectId  INT,
                @Respondent VARCHAR(10),
                @Action     INT
AS
IF ( @Action = 3 )
BEGIN
    -- Reset QTOnline
    UPDATE Quota SET QtOnline = 0;
END 
ELSE 
BEGIN
    -- define the operation direction
    DECLARE  @Modifier INT;
    IF ( @Action = 1 ) SET @Modifier = 1;
    ELSE If ( @Action = 2 ) SET @Modifier = -1;

    --Fetch list of Quotas to update (force S-lock on Stratum first to avoid some deadlock)
    DECLARE @quotaIdList TABLE(QuotaId int, IncrementValue int);
    INSERT INTO @quotaIdList 
	SELECT StrQuotaId, IsNull(IncrementValue,1) * @Modifier 
	       FROM Stratum 
		   WHERE StrRespondent = @Respondent 
		   AND IncrementValue <> 0;

    --Increment or Decrement  Quota.QtOnLine for strata that the respondent belong
    UPDATE q
    SET q.QtOnLine = q.QtOnLine + IncrementValue
    FROM Quota q
    INNER JOIN @quotaIdList l ON q.QtQuotaId = l.QuotaId
    WHERE q.QtStratum > 0
END
GO

